@extends('layouts.default')
@section('conteudo')
    <h3>
        Registrar Pagamento
        <a href="{{url('financeiro/historico?cliente='.$cliente->id)}}" class="material-icons float-right" style="font-size: 1.3em; color: #333;">
            keyboard_backspace
        </a>  
    </h3>
    <hr>

    <form id="formulario" method="post" action="{{ url('financeiro/store') }}" autocomplete="off" onsubmit="salvar(this)">
        {{ @csrf_field() }}

        <input type="hidden" name="id" value="">
        <input type="hidden" name="id_cliente" value="{{$cliente->id}}">

        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <div><label>Cliente</label></div>
                    <input type="text" disabled value="{{$cliente->nome}}" class="form-control">
                </div>
            </div>
            <div class="col-md-3 col-3">
                <div class="form-group">
                    <div><label>Mês</label></div>
                    <select name="mes" id="mes" class="form-control" required onchange="changeVencimento()">
                        <option value="">Todos...</option>
                        @foreach($meses as $i => $mes)
                            <option {{ (date('m')==$i) ? 'selected' : '' }} value="{{ $i }}">{{ $mes }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="col-md-3 col-3">
                <div class="form-group">
                    <div><label>Ano</label></div>
                    <select name="ano" id="ano" class="form-control" required onchange="changeVencimento()">
                        @foreach($anoRef as $ano)
                            <option {{ (date('Y')==$ano) ? 'selected' : '' }} value="{{ $ano }}">{{ $ano }}</option>
                        @endforeach
                    </select>
                </div>
            </div>            
        </div>

        <div class="row">
            <div class="col-md-3 col-3">
                <div class="form-group">
                    <div><label>Valor do Titular</label></div>
                    <input type="tel" name="valorTitular" value="{{$cliente->valorCliente}}" readonly required class="form-control">
                </div>
            </div>
            <div class="col-md-3 col-3">
                <div class="form-group">
                    <div><label>Valor Dependentes Extra</label></div>
                    <input type="tel" name="valorDependentes" value="{{number_format($cliente->valorDependentes, 2)}}" readonly required class="form-control">
                </div>
            </div>
            <div class="col-md-3 col-3">
                <div class="form-group">
                    <div><label>Qtd. de Dependentes</label></div>
                    <input type="text" name="dependentes" value="{{$cliente->dependentes}}" readonly required class="form-control">
                </div>
            </div>
            
            <div class="col-md-3 col-3">
                <div class="form-group">
                    <div><label>Vencimento</label></div>
                    <input type="date" name="dtVencimento" id="dtVencimento" class="form-control" required readonly>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-3">
                <div class="form-group">
                    <div><label>Valor da Cobrança</label></div>
                    <input type="tel" name="valorTotalCobranca" value="{{number_format($cliente->valorCobranca, 2, ',', '.')}}" required readonly class="form-control">
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <div><label>Valor Pago</label></div>
                    <input type="tel" name="valorPago" value="{{number_format($cliente->valorCobranca, 2, ',', '.')}}" class="form-control" required>
                </div>
            </div>
            <div class="col-md-3 col-3">
                <div class="form-group">
                    <div><label>Data do Pagamento</label></div>
                    <input type="date" name="dtPagamento" class="form-control" required>
                </div>
            </div>
            <div class="col-md-3 col-3">
                <div class="form-group">
                    <div><label>Forma de Pagamento</label></div>
                    <select name="formaPagamento" class="form-control" required>
                        <option value="">SELECIONE...</option>
                        @foreach($formasPagamento as $tipo)
                            <option value="{{$tipo->id}}">{{$tipo->nome}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    <div><label>Observacao</label></div>
                    <textarea name="observacao" class="form-control">Registrado o pagamento referente ao mês de...</textarea>
                </div>
            </div>
        </div>

        
        <div id="divError" class="alert alert-danger d-none"></div>

        <div class="row">
            <div class="form-group">
                <button type="submit" id="btnSalvar" class="btn btn-parque ml-3 btn"><i class="material-icons icone">save</i> Salvar</button>
            </div>
        </div>

    </form>

@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
<script>
    var form = document.getElementById('formulario');
    var mes = document.getElementById('mes');
    var ano = document.getElementById('ano');
    var dtVencimento = document.getElementById('dtVencimento');
    var divError = document.getElementById('divError');

    function changeVencimento(){
        dtVencimento.value = ""+ano.value+"-"+mes.value+"-{{$cliente->dia_vencimento}}";
    }

    changeVencimento();

    function salvar(e) {
        event.preventDefault();

        var formData = new FormData(form);

        axios.post(e.action, formData)
            .then((response) => {
                console.log(response);
                window.location = BASE_URL+'financeiro/historico?cliente='+<?= $cliente->id ?>;
            })
            .catch((error) => {
                console.log(error.response.data.error);
                divError.innerHTML = error.response.data.error;
                divError.classList.remove('d-none');
            })
    }
</script>
@endsection
